%------------------------------------------------------------------------------
% File     : SEU793^2 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Set Theory
% Problem  : More about Functions - Images of Functions
% Version  : Especial > Reduced > Especial.
% English  : (! A:i.! f:i>i.? B:i.! x:i.in x B <-> (? y:i.in y A & x = f y))

% Refs     : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    : ZFC295l [Bro08]

% Status   : Theorem
% Rating   : 0.57 v7.4.0, 0.22 v7.3.0, 0.33 v7.2.0, 0.38 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.29 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0, 0.60 v4.1.0, 0.67 v3.7.0
% Syntax   : Number of formulae    :    6 (   0 unit;   3 type;   2 defn)
%            Number of atoms       :   38 (   4 equality;  25 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   27 (   0   ~;   0   |;   3   &;  18   @)
%                                         (   2 <=>;   4  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    8 (   8   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :   15 (   0 sgn;   8   !;   5   ?;   2   ^)
%                                         (  15   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : http://mathgate.info/detsetitem.php?id=415
%          : 
%------------------------------------------------------------------------------
thf(in_type,type,(
    in: $i > $i > $o )).

thf(exu_type,type,(
    exu: ( $i > $o ) > $o )).

thf(exu,definition,
    ( exu
    = ( ^ [Xphi: $i > $o] :
        ? [Xx: $i] :
          ( ( Xphi @ Xx )
          & ! [Xy: $i] :
              ( ( Xphi @ Xy )
             => ( Xx = Xy ) ) ) ) )).

thf(replAx_type,type,(
    replAx: $o )).

thf(replAx,definition,
    ( replAx
    = ( ! [Xphi: $i > $i > $o,A: $i] :
          ( ! [Xx: $i] :
              ( ( in @ Xx @ A )
             => ( exu
                @ ^ [Xy: $i] :
                    ( Xphi @ Xx @ Xy ) ) )
         => ? [B: $i] :
            ! [Xx: $i] :
              ( ( in @ Xx @ B )
            <=> ? [Xy: $i] :
                  ( ( in @ Xy @ A )
                  & ( Xphi @ Xy @ Xx ) ) ) ) ) )).

thf(image1Ex,conjecture,
    ( replAx
   => ! [A: $i,Xf: $i > $i] :
      ? [B: $i] :
      ! [Xx: $i] :
        ( ( in @ Xx @ B )
      <=> ? [Xy: $i] :
            ( ( in @ Xy @ A )
            & ( Xx
              = ( Xf @ Xy ) ) ) ) )).

%------------------------------------------------------------------------------
